/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.item;

import com.google.common.base.Strings;
import com.mojang.bridge.game.Language;
import com.simibubi.create.content.AllSections;
import com.simibubi.create.content.contraptions.goggles.GogglesItem;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.FontHelper;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.util.MinecraftClientUtil;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1074;
import net.minecraft.class_1077;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;

public class TooltipHelper {
    public static final int maxWidthPerLine = 200;
    public static final Map<String, ItemDescription> cachedTooltips = new HashMap<String, ItemDescription>();
    public static Language cachedLanguage;
    private static boolean gogglesMode;
    private static final Map<class_1792, Supplier<String>> tooltipReferrals;

    public static class_5250 holdShift(ItemDescription.Palette color, boolean highlighted) {
        return Lang.translateDirect("tooltip.holdForDescription", Lang.translateDirect("tooltip.keyShift", new Object[0]).method_27692(class_124.field_1080)).method_27692(class_124.field_1063);
    }

    public static void addHint(List<class_2561> tooltip, String hintKey, Object ... messageParams) {
        class_2561 spacing = IHaveGoggleInformation.componentSpacing;
        tooltip.add((class_2561)spacing.method_27662().method_10852((class_2561)Lang.translateDirect(hintKey + ".title", new Object[0])).method_27692(class_124.field_1065));
        class_5250 hint = Lang.translateDirect(hintKey, new Object[0]);
        List<class_2561> cutComponent = TooltipHelper.cutTextComponent((class_2561)hint, class_124.field_1080, class_124.field_1068);
        for (class_2561 component : cutComponent) {
            tooltip.add((class_2561)spacing.method_27662().method_10852(component));
        }
    }

    public static void referTo(class_1935 item, Supplier<? extends class_1935> itemWithTooltip) {
        tooltipReferrals.put(item.method_8389(), () -> ((class_1935)itemWithTooltip.get()).method_8389().method_7876());
    }

    public static void referTo(class_1935 item, String string) {
        tooltipReferrals.put(item.method_8389(), () -> string);
    }

    @Deprecated
    public static List<String> cutString(class_2561 s, class_124 defaultColor, class_124 highlightColor) {
        return TooltipHelper.cutString(s.getString(), defaultColor, highlightColor, 0);
    }

    @Deprecated
    public static List<String> cutString(String s, class_124 defaultColor, class_124 highlightColor, int indent) {
        String markedUp = s.replaceAll("_([^_]+)_", highlightColor + "$1" + defaultColor);
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(MinecraftClientUtil.getLocale());
        iterator.setText(markedUp);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = markedUp.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        class_327 font = class_310.method_1551().field_1772;
        List<String> lines = FontHelper.cutString(font, markedUp, 200);
        String lineStart = Strings.repeat((String)" ", (int)indent);
        ArrayList<String> formattedLines = new ArrayList<String>(lines.size());
        String format = defaultColor.toString();
        for (String line : lines) {
            String formattedLine = format + lineStart + line;
            formattedLines.add(formattedLine);
        }
        return formattedLines;
    }

    public static List<class_2561> cutStringTextComponent(String c, class_124 defaultColor, class_124 highlightColor) {
        return TooltipHelper.cutTextComponent((class_2561)Components.literal(c), defaultColor, highlightColor, 0);
    }

    public static List<class_2561> cutTextComponent(class_2561 c, class_124 defaultColor, class_124 highlightColor) {
        return TooltipHelper.cutTextComponent(c, defaultColor, highlightColor, 0);
    }

    public static List<class_2561> cutStringTextComponent(String c, class_124 defaultColor, class_124 highlightColor, int indent) {
        return TooltipHelper.cutTextComponent((class_2561)Components.literal(c), defaultColor, highlightColor, indent);
    }

    public static List<class_2561> cutTextComponent(class_2561 c, class_124 defaultColor, class_124 highlightColor, int indent) {
        String s;
        String markedUp = s = c.getString();
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(MinecraftClientUtil.getLocale());
        iterator.setText(markedUp);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = markedUp.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        class_327 font = class_310.method_1551().field_1772;
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.method_1727(word.replaceAll("_", ""));
            if (width + newWidth > 200) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        class_5250 lineStart = Components.literal(Strings.repeat((String)" ", (int)indent));
        lineStart.method_27692(defaultColor);
        ArrayList<class_2561> formattedLines = new ArrayList<class_2561>(lines.size());
        Couple<class_124> f = Couple.create(highlightColor, defaultColor);
        boolean currentlyHighlighted = false;
        for (String string : lines) {
            String[] split;
            class_5250 currentComponent = lineStart.method_27662();
            for (String part : split = string.split("_")) {
                currentComponent.method_10852((class_2561)Components.literal(part).method_27692(f.get(currentlyHighlighted)));
                currentlyHighlighted = !currentlyHighlighted;
            }
            formattedLines.add((class_2561)currentComponent);
            currentlyHighlighted = !currentlyHighlighted;
        }
        return formattedLines;
    }

    private static void checkLocale() {
        class_1077 currentLanguage = class_310.method_1551().method_1526().method_4669();
        if (cachedLanguage != currentLanguage) {
            cachedTooltips.clear();
            cachedLanguage = currentLanguage;
        }
    }

    public static boolean hasTooltip(class_1799 stack, class_1657 player) {
        String key;
        TooltipHelper.checkLocale();
        boolean hasGoggles = GogglesItem.isWearingGoggles(player);
        if (hasGoggles != gogglesMode) {
            gogglesMode = hasGoggles;
            cachedTooltips.clear();
        }
        if (cachedTooltips.containsKey(key = TooltipHelper.getTooltipTranslationKey(stack))) {
            return cachedTooltips.get(key) != ItemDescription.MISSING;
        }
        return TooltipHelper.findTooltip(stack);
    }

    public static ItemDescription getTooltip(class_1799 stack) {
        ItemDescription itemDescription;
        TooltipHelper.checkLocale();
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (cachedTooltips.containsKey(key) && (itemDescription = cachedTooltips.get(key)) != ItemDescription.MISSING) {
            return itemDescription;
        }
        return null;
    }

    private static boolean findTooltip(class_1799 stack) {
        String key = TooltipHelper.getTooltipTranslationKey(stack);
        if (class_1074.method_4663((String)key)) {
            cachedTooltips.put(key, TooltipHelper.buildToolTip(key, stack));
            return true;
        }
        cachedTooltips.put(key, ItemDescription.MISSING);
        return false;
    }

    private static ItemDescription buildToolTip(String translationKey, class_1799 stack) {
        int i;
        AllSections module = AllSections.of(stack);
        ItemDescription tooltip = new ItemDescription(module.getTooltipPalette());
        String summaryKey = translationKey + ".summary";
        if (class_1074.method_4663((String)summaryKey)) {
            tooltip = tooltip.withSummary((class_2561)Components.literal(class_1074.method_4662((String)summaryKey, (Object[])new Object[0])));
        }
        for (i = 1; i < 100; ++i) {
            String conditionKey = translationKey + ".condition" + i;
            String behaviourKey = translationKey + ".behaviour" + i;
            if (!class_1074.method_4663((String)conditionKey)) break;
            if (i == 1) {
                tooltip.getLinesOnShift().add(Components.immutableEmpty());
            }
            tooltip.withBehaviour(class_1074.method_4662((String)conditionKey, (Object[])new Object[0]), class_1074.method_4662((String)behaviourKey, (Object[])new Object[0]));
        }
        for (i = 1; i < 100; ++i) {
            String controlKey = translationKey + ".control" + i;
            String actionKey = translationKey + ".action" + i;
            if (!class_1074.method_4663((String)controlKey)) break;
            tooltip.withControl(class_1074.method_4662((String)controlKey, (Object[])new Object[0]), class_1074.method_4662((String)actionKey, (Object[])new Object[0]));
        }
        return tooltip.createTabs();
    }

    public static String getTooltipTranslationKey(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (tooltipReferrals.containsKey(item)) {
            return tooltipReferrals.get(item).get() + ".tooltip";
        }
        return item.method_7866(stack) + ".tooltip";
    }

    static {
        tooltipReferrals = new HashMap<class_1792, Supplier<String>>();
    }
}

